/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.dialog;

import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.VWTrkDataModel;
import filenet.vw.toolkit.runtime.VWTrkParticipant;
import filenet.vw.toolkit.runtime.VWTrkStepOccurrence;
import filenet.vw.toolkit.runtime.dialog.VWUnlockWork;
import filenet.vw.toolkit.runtime.resources.VWResource;
import filenet.vw.toolkit.utils.VWHelp;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import filenet.vw.toolkit.utils.table.VWParticipantItem;
import filenet.vw.toolkit.utils.table.VWTable;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumn;

public final class VWUnlockWorkDialog
extends VWModalDialog {
    static final int COL_CHECK_BOX = 0;
    static final int COL_STEP = 1;
    static final int COL_PARTICIPANT = 2;
    static final int COL_LOCKED_BY = 3;
    private boolean m_bCanceled = true;
    private Vector m_participants = null;
    private JTextArea m_infoTextArea = null;
    private VWTable m_table = null;
    private VWLockWorkTableModel m_tableModel = null;
    private VWUnlockWork m_unlockWork;
    private JButton m_okButton = null;
    private ActionListener m_okButtonActionListener = null;
    private JButton m_cancelButton = null;
    private ActionListener m_cancelButtonActionListener = null;
    private JButton m_helpButton = null;
    private ActionListener m_helpButtonActionListener = null;

    public VWUnlockWorkDialog(Frame parent, VWTrkDataModel dataModel) throws Exception {
        super(parent);
        Vector steps = dataModel.getStepCollection();
        this.m_unlockWork = new VWUnlockWork(parent, dataModel, steps);
        this.initialize();
    }

    public VWUnlockWorkDialog(Frame parent, VWTrkDataModel dataModel, Vector steps) throws Exception {
        super(parent);
        this.m_unlockWork = new VWUnlockWork(parent, dataModel, steps);
        this.initialize();
    }

    public VWUnlockWorkDialog(Frame parent, VWTrkStepOccurrence occurrence) throws Exception {
        super(parent);
        this.m_unlockWork = new VWUnlockWork(parent, occurrence);
        this.initialize();
    }

    public VWUnlockWorkDialog(Frame parent, VWTrkParticipant participant) throws Exception {
        super(parent);
        this.m_unlockWork = new VWUnlockWork(parent, participant);
        this.initialize();
    }

    private void initialize() throws Exception {
        this.m_participants = this.m_unlockWork.getParticipants();
        this.m_tableModel = new VWLockWorkTableModel();
        this.setupLayout();
    }

    private void setupLayout() {
        try {
            JPanel centerPanel = new JPanel();
            JPanel buttonPanel = new JPanel();
            Container container = this.getContentPane();
            this.setResizable(true);
            Dimension dim = VWStringUtils.stringToDimension(VWResource.s_unlockWorkDialogDim);
            if (dim == null) {
                dim = new Dimension(450, 350);
            }
            this.setSize(dim.width, dim.height);
            this.setVisible(false);
            this.setTitle(VWResource.s_unlockDialogTitle);
            this.m_infoTextArea = new JTextArea(VWResource.s_unlockInfo);
            this.m_infoTextArea.setLineWrap(true);
            this.m_infoTextArea.setWrapStyleWord(true);
            this.m_infoTextArea.setOpaque(false);
            this.m_infoTextArea.setEditable(false);
            this.m_table = new VWTable(this.m_tableModel);
            this.m_table.setEnabled(true);
            this.m_table.setShowGrid(true);
            TableColumn tc = this.m_table.getColumnModel().getColumn(0);
            tc.setMaxWidth(20);
            tc.setMinWidth(20);
            JScrollPane scrollPane = new JScrollPane(this.m_table);
            this.m_okButton = new JButton(VWResource.s_ok);
            this.m_cancelButton = new JButton(VWResource.s_cancel);
            this.m_helpButton = new JButton(VWResource.s_help);
            centerPanel.setLayout(new BoxLayout(centerPanel, 3));
            centerPanel.add(this.m_infoTextArea);
            centerPanel.add(Box.createVerticalStrut(10));
            centerPanel.add(scrollPane);
            centerPanel.add(Box.createVerticalStrut(10));
            buttonPanel.setLayout(new FlowLayout());
            buttonPanel.add(this.m_okButton);
            buttonPanel.add(this.m_cancelButton);
            buttonPanel.add(this.m_helpButton);
            buttonPanel.add(Box.createHorizontalStrut(20));
            JPanel mainPanel = new JPanel();
            mainPanel.setLayout(new BorderLayout());
            mainPanel.add((Component)centerPanel, "Center");
            mainPanel.add((Component)buttonPanel, "Last");
            container.setLayout(new BorderLayout());
            container.add((Component)mainPanel, "Center");
            container.add(Box.createVerticalStrut(20), "First");
            container.add(Box.createHorizontalStrut(20), "Before");
            container.add(Box.createHorizontalStrut(20), "After");
            container.add(Box.createVerticalStrut(20), "Last");
            this.m_okButtonActionListener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    VWUnlockWorkDialog.this.m_unlockWork.unlockWork(VWUnlockWorkDialog.this.m_tableModel.getSelectionFlags());
                    VWUnlockWorkDialog.this.m_bCanceled = false;
                    VWUnlockWorkDialog.this.setVisible(false);
                }
            };
            this.m_okButton.addActionListener(this.m_okButtonActionListener);
            this.m_cancelButtonActionListener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    VWUnlockWorkDialog.this.m_bCanceled = true;
                    VWUnlockWorkDialog.this.setVisible(false);
                }
            };
            this.m_cancelButton.addActionListener(this.m_cancelButtonActionListener);
            this.m_helpButtonActionListener = new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    VWHelp.displayPage(VWHelp.Help_Process_Tracker + "bpfpt042.htm");
                }
            };
            this.m_helpButton.addActionListener(this.m_helpButtonActionListener);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void addNotify() {
        super.addNotify();
    }

    public void removeReferences() {
        super.removeReferences();
        this.m_participants = null;
        this.m_infoTextArea = null;
        if (this.m_table != null) {
            this.m_table.removeReferences();
            this.m_table = null;
        }
        if (this.m_tableModel != null) {
            this.m_tableModel.removeReferences();
            this.m_tableModel = null;
        }
        if (this.m_unlockWork != null) {
            this.m_unlockWork.removeReferences();
            this.m_unlockWork = null;
        }
        if (this.m_okButton != null) {
            this.m_okButton.removeActionListener(this.m_okButtonActionListener);
            this.m_okButtonActionListener = null;
            this.m_okButton = null;
        }
        if (this.m_helpButton != null) {
            this.m_helpButton.removeActionListener(this.m_helpButtonActionListener);
            this.m_helpButtonActionListener = null;
            this.m_helpButton = null;
        }
        if (this.m_cancelButton != null) {
            this.m_cancelButton.removeActionListener(this.m_cancelButtonActionListener);
            this.m_cancelButtonActionListener = null;
            this.m_cancelButton = null;
        }
        this.removeAll();
    }

    private class VWLockWorkTableModel
    extends AbstractTableModel {
        Vector m_data = null;
        boolean[] m_selected = null;
        int m_count = 0;
        String[] m_columnNames = new String[]{"", VWResource.s_step, VWResource.s_participant, VWResource.s_lockedBy};

        VWLockWorkTableModel() {
            this.m_data = VWUnlockWorkDialog.this.m_unlockWork.getParticipants();
            if (this.m_data == null) {
                this.m_count = 0;
                return;
            }
            this.m_count = this.m_data.size();
            if (this.m_count > 0) {
                this.m_selected = new boolean[this.m_count];
                for (int i = 0; i < this.m_count; ++i) {
                    this.m_selected[i] = true;
                }
            }
        }

        public int getRowCount() {
            return this.m_count;
        }

        public int getColumnCount() {
            return this.m_columnNames.length;
        }

        public boolean isCellEditable(int row, int col) {
            if (row < 0 || row >= this.m_count) {
                return false;
            }
            return col == 0;
        }

        public String getColumnName(int col) {
            if (col < 0 || col >= this.m_columnNames.length) {
                return null;
            }
            return this.m_columnNames[col];
        }

        public Class getColumnClass(int col) {
            switch (col) {
                case 0: {
                    return Boolean.class;
                }
                case 1: 
                case 2: 
                case 3: {
                    return String.class;
                }
            }
            return null;
        }

        public Object getValueAt(int row, int col) {
            if (row < 0 || row >= this.m_count) {
                return null;
            }
            VWTrkParticipant participant = null;
            Object obj = this.m_data.elementAt(row);
            if (obj == null || !(obj instanceof VWTrkParticipant)) {
                return null;
            }
            participant = (VWTrkParticipant)obj;
            switch (col) {
                case 0: {
                    return new Boolean(this.m_selected[row]);
                }
                case 1: {
                    return participant.getStep().getStepName();
                }
                case 2: {
                    VWParticipantItem parItem = new VWParticipantItem(participant.getParticipant());
                    return parItem.getDisplayName();
                }
                case 3: {
                    return participant.getLockedUser();
                }
            }
            return null;
        }

        public void setValueAt(Object value, int row, int col) {
            if (row < 0 || row >= this.m_count || col != 0) {
                return;
            }
            if (value instanceof Boolean) {
                this.m_selected[row] = (Boolean)value;
            }
        }

        public boolean[] getSelectionFlags() {
            return this.m_selected;
        }

        public void removeReferences() {
            this.m_data = null;
            for (int i = 0; i < this.m_columnNames.length; ++i) {
                this.m_columnNames[i] = null;
            }
            this.m_columnNames = null;
            this.m_selected = null;
        }
    }
}

